/*
 * Copyright (C) 2008-2012 Freescale Semiconductor, Inc. All Rights Reserved.
 */
/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#include <linux/linkage.h>
#include <mach/hardware.h>
#include <mach/mx51.h>
#include <mach/mx53.h>



//;------------------------------------------------------------------------------
//;
//;   Copyright (C) 2007-2011, Freescale Semiconductor, Inc. All Rights Reserved.
//;   THIS SOURCE CODE, AND ITS USE AND DISTRIBUTION, IS SUBJECT TO THE TERMS
//;   AND CONDITIONS OF THE APPLICABLE LICENSE AGREEMENT
//;
//;------------------------------------------------------------------------------
//;
//;  Module: suspend.s
//;
//;  This module implements the OAL assembly-level support for placing the
//;  system in suspend mode.
//;
//;------------------------------------------------------------------------------

#define ARM_CTRL_DCACHE  1 << 2
#define ARM_CTRL_ICACHE  1 << 12
#define ARM_AUXCR_L2EN   1 << 1

#define MX51_DRAM_SDCLK_PAD_CTRL_ADDR MX51_IO_ADDRESS(0x73FA84B8)
#define MX51_CCM_BASE MX51_IO_ADDRESS(0x73fd4000)
#define MX51_PLL1_BASE MX51_IO_ADDRESS(0x83f80000)

#define M4IF_MCR0_OFFSET	(0x008C)
#define M4IF_MCR0_FDVFS		(0x1 << 11)
#define M4IF_MCR0_FDVACK	(0x1 << 27)
#define IOMUXC_BASE_ADDR_VIRT	MX53_IO_ADDRESS(MX53_IOMUXC_BASE_ADDR)
#define M4IF_BASE_ADDR_VIRT	MX53_IO_ADDRESS(MX53_M4IF_BASE_ADDR)

.macro PM_SET_BACKUP_REG, addr, num
	ldr r2, =\addr
	ldr r2, [r1, r2]
	str r2, [r3, #(\num * 4)]
.endm

.macro PM_SET_HIGHZ_PAD, addr
	ldr r2, =\addr
	str r4, [r1, r2]
.endm

.macro PM_SET_RESTORE_REG, addr, num
    ldr     r4, [r3, #(\num * 4)]
    ldr     r2, =\addr
    str     r4, [r1, r2]
.endm


#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3		0x554
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3	0x558
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2		0x560
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT1	0x564
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2	0x568
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_1	0x570
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS		0x574
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_0	0x578
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0	0x57c
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT0	0x580
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0		0x584
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS		0x588
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1	0x590
#define IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1		0x594
#define IOMUXC_SW_PAD_CTL_GRP_ADDDS			0x6f0
#define IOMUXC_SW_PAD_CTL_GRP_B0DS			0x718
#define IOMUXC_SW_PAD_CTL_GRP_B1DS			0x71c
#define IOMUXC_SW_PAD_CTL_GRP_CTLDS			0x720
#define IOMUXC_SW_PAD_CTL_GRP_B2DS			0x728
#define IOMUXC_SW_PAD_CTL_GRP_B3DS			0x72c


//;------------------------------------------------------------------------------
//;
//;  Function: OALCPUEnterSuspend
//;
//;  This function provides the instruction sequence for requesting the ARM CPU
//;  to enter the WFI (wait-for-interrupt).  This routine will be called by
//;  the OEMPowerOff.
//;
//;  Parameters:
//;      None.
//;
//;  Returns:
//;      None.
//;
//;------------------------------------------------------------------------------
ENTRY(cpu_do_suspend_workaround)

    //; Save registers
    stmfd   sp!, {r4,r5,r6,r7,r9,r10,r11}     @ Save registers
    
    //; Point R0 at M4IF register set
    ldr     r0, =M4IF_BASE_ADDR_VIRT

    /* Point R1 at IOMUX register set */
    ldr     r1, =IOMUXC_BASE_ADDR_VIRT

    /* Point R3 at temporary IRAM storage for DDR pad config */
    adr     r3, __mx5x_temp_stack

	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3,		0
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3, 	1
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2,		2
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT1,	3
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2, 	4
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_1,	5
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS,		6
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_0,	7
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0,		8
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT0,	9
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0,		10
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS,		11
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1, 	12
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1,		13
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_GRP_ADDDS,			14
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_GRP_B0DS,			15
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_GRP_B1DS, 			16
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_GRP_CTLDS,			17
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_GRP_B2DS, 			18
	PM_SET_BACKUP_REG IOMUXC_SW_PAD_CTL_GRP_B3DS, 			19

    //; Set FDVFS bit of M4IF_MCR0 to request DDR to enter self-refresh
    ldr     r2,[r0, #M4IF_MCR0_OFFSET]
    orr     r2, r2, #M4IF_MCR0_FDVFS
    str     r2,[r0, #M4IF_MCR0_OFFSET]

    //; Poll FDVACK bit of M4IF_MCR to wait for DDR to enter self-refresh entry
WAIT_SR_ACK:
    ldr     r2,[r0, #M4IF_MCR0_OFFSET]
    ands    r2, r2, #M4IF_MCR0_FDVACK
    beq     WAIT_SR_ACK
    
    /*
     * Set DSE of all DDR I/O pads to 0 => HighZ
     * except CKE which must drive during self-refresh
     * according to JEDEC
	 */

    ldr     r4, =0
	PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3
//*    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3	// JAS: Changing the SDQSx registers causes corruption
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT1
//*    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_1
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_0
//*    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT0
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS
//*    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_GRP_ADDDS
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_GRP_B0DS
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_GRP_B1DS
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_GRP_CTLDS
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_GRP_B2DS
    PM_SET_HIGHZ_PAD IOMUXC_SW_PAD_CTL_GRP_B3DS



    wfi
    


    ldr     r0, =M4IF_BASE_ADDR_VIRT
    ldr     r1, =IOMUXC_BASE_ADDR_VIRT
    adr     r3, __mx5x_temp_stack
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3,		0
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3, 	1
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2,		2
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT1,	3
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2, 	4
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_1,	5
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS,		6
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK_0,	7
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0,	8
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDODT0,	9
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0,		10
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS,		11
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1, 	12
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1,		13
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_GRP_ADDDS,			14
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_GRP_B0DS,			15
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_GRP_B1DS, 			16
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_GRP_CTLDS,			17
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_GRP_B2DS, 			18
	PM_SET_RESTORE_REG IOMUXC_SW_PAD_CTL_GRP_B3DS, 			19

    //; Clear FDVFS bit of M4IF_MCR0 to request DDR to exit self-refresh
    ldr     r2,[r0, #M4IF_MCR0_OFFSET]
    bic     r2, r2, #M4IF_MCR0_FDVFS
    str     r2,[r0, #M4IF_MCR0_OFFSET]

    //; Poll FDVACK bit of M4IF_MCR to wait for DDR to exit self-refresh entry
WAIT_AR_ACK:
    ldr     r2,[r0, #M4IF_MCR0_OFFSET]
    ands    r2, r2, #M4IF_MCR0_FDVACK
    bne     WAIT_AR_ACK

    //; Restore registers
    ldmfd sp!, {r4,r5,r6,r7,r9,r10,r11}

    mov		pc, lr

__mx5x_temp_stack:
	.space 128

	.type	cpu_do_suspend, #object
ENTRY(cpu_do_suspend)
	.word	cpu_do_suspend_workaround
	.size	cpu_do_suspend_workaround, . - cpu_do_suspend_workaround
